package commons.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ResourceBundle.Control;

public class ResourceBundleUtil {

	public static ResourceBundle getBundleNoCache(String bundleName) {
		return getBundleNoCache(bundleName, Locale.getDefault(), Thread
				.currentThread().getContextClassLoader());
	}

	public static ResourceBundle getBundleNoCache(String bundleName,
			ClassLoader loader) {
		return getBundleNoCache(bundleName, Locale.getDefault(), loader);
	}

	public static ResourceBundle getBundleNoCache(String bundleName,
			Locale locale) {
		return getBundleNoCache(bundleName, locale, Thread.currentThread()
				.getContextClassLoader());
	}

	public static ResourceBundle getBundleNoCache(String bundleName,
			Locale locale, ClassLoader loader) {
		try {
			return ResourceBundle.getBundle(bundleName, locale, loader,
					new ResourceBundle.Control() {

						@Override
						public long getTimeToLive(String baseName, Locale locale) {
							return Control.TTL_DONT_CACHE;
						}

					});
		} catch (MissingResourceException e) {
			return null;
		}
	}

}
