package commons.util;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

import commons.exception.ReflectionRuntimeException;

/**
 * 
 * @author shot
 * 
 */
public class ReflectionExecutor {

	protected ReflectionExecutor() {
	}

	public static <T> T doAction(final ReflectionAction<T> action) {
		Assertion.notNull(action);
		try {
			return AccessController
					.doPrivileged(new PrivilegedExceptionAction<T>() {

						@Override
						public T run() throws Exception {
							return action.run();
						}

					});
		} catch (PrivilegedActionException e) {
			Throwable cause = e.getCause();
			if (InvocationTargetException.class.isInstance(cause)) {
				InvocationTargetException e1 = (InvocationTargetException) cause;
				throw new ReflectionRuntimeException(e1.getTargetException());
			}
			throw new ReflectionRuntimeException(cause);
		}
	}

	public static interface ReflectionAction<T> {

		T run() throws Exception;

	}
}
