package commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

import commons.exception.FileNotFoundRuntimeException;

/**
 * Reader utility.
 * 
 * @author shot
 * 
 */
public class ReaderUtil {

	public static BufferedReader createBufferedReader(final InputStream is) {
		Assertion.notNull(is);
		return createBufferedReader(new InputStreamReader(is));
	}

	public static BufferedReader createBufferedReader(final Reader reader) {
		Assertion.notNull(reader);
		return new BufferedReader(reader);
	}

	public static BufferedReader createBufferedReader(final File file) {
		Assertion.notNull(file);
		try {
			return createBufferedReader(new FileReader(file));
		} catch (FileNotFoundException e) {
			throw new FileNotFoundRuntimeException(e, file);
		}
	}

	public static BufferedReader createBufferedReader(final String csv) {
		Assertion.notNull(csv);
		return createBufferedReader(new StringReader(csv));
	}

}
