package commons.util;

import org.slf4j.LoggerFactory;

import commons.Disposable;

/**
 * Simple logger with slf4j.
 * 
 * @author shot
 * @see org.slf4j.LoggerFactory
 */
public class Logger implements Disposable {

	protected org.slf4j.Logger logger_;

	protected Logger(final String name) {
		logger_ = LoggerFactory.getLogger(name);
	}

	protected Logger(final Class<?> clazz) {
		logger_ = LoggerFactory.getLogger(clazz);
	}

	public static Logger getLogger(final String name) {
		Logger logger = new Logger(Assertion.notNull(name));
		return logger;
	}

	public static Logger getLogger(final Class<?> clazz) {
		Logger logger = new Logger(Assertion.notNull(clazz));
		return logger;
	}

	public Logger debug(String message) {
		if (isDebugEnabled()) {
			logger_.debug(message);
		}
		return this;
	}

	public Logger debug(String message, Object... args) {
		if (isDebugEnabled()) {
			logger_.debug(message, args);
		}
		return this;
	}

	public Logger info(String message) {
		if (isInfoEnabled()) {
			logger_.info(message);
		}
		return this;
	}

	public Logger info(String message, Object... args) {
		if (isInfoEnabled()) {
			logger_.info(message, args);
		}
		return this;
	}

	public Logger error(String message) {
		if (isErrorEnabled()) {
			logger_.error(message);
		}
		return this;
	}

	public Logger error(String message, Object... args) {
		if (isErrorEnabled()) {
			logger_.error(message, args);
		}
		return this;
	}

	public Logger warn(String message) {
		if (isWarnEnabled()) {
			logger_.warn(message);
		}
		return this;
	}

	public Logger warn(String message, Object... args) {
		if (isWarnEnabled()) {
			logger_.warn(message, args);
		}
		return this;
	}

	public Logger trace(String message) {
		if (logger_.isTraceEnabled()) {
			logger_.trace(message);
		}
		return this;
	}

	public Logger trace(String message, Object... args) {
		if (isTraceEnabled()) {
			logger_.trace(message, args);
		}
		return this;
	}

	public boolean isDebugEnabled() {
		return logger_.isDebugEnabled();
	}

	public boolean isInfoEnabled() {
		return logger_.isInfoEnabled();
	}

	public boolean isErrorEnabled() {
		return logger_.isErrorEnabled();
	}

	public boolean isTraceEnabled() {
		return logger_.isTraceEnabled();
	}

	public boolean isWarnEnabled() {
		return logger_.isWarnEnabled();
	}

	/**
	 * Maybe need to some clear method to LoggerFactory, like Log4j.
	 */
	public void dispose() {
	}

	public void log(String messageCode, Throwable e, Object... args) {
		Assertion.notNull(messageCode);
		char messageType = messageCode.charAt(0);
		String message = MessageFormatter.getSimpleMessage(messageCode, args);
		switch (messageType) {
		case 'D':
			debug(message);
			break;
		case 'I':
			info(message);
			break;
		case 'E':
			error(message);
			break;
		case 'T':
			trace(message);
			break;
		case 'W':
			warn(message);
			break;
		default:
			break;
		}
	}

}
