package commons.util;

import java.beans.Introspector;
import java.lang.reflect.Method;

import commons.Constants;
import commons.util.Reflections.MethodUtil;

/**
 * JavaBeans utility.
 * 
 * @author shot
 * 
 */
public class JavaBeansUtil {

	protected JavaBeansUtil() {
	}

	public static String capitalize(String name) {
		if (StringUtil.isEmpty(name)) {
			return name;
		}
		char chars[] = name.toCharArray();
		chars[0] = Character.toUpperCase(chars[0]);
		return new String(chars);
	}

	public static String decapitalize(String name) {
		return Introspector.decapitalize(name);
	}

	public static String getPropertyName(String methodName) {
		if (methodName == null) {
			return null;
		}
		if (methodName.startsWith("get") || methodName.startsWith("set")) {
			String s = methodName.substring(3, methodName.length());
			return decapitalize(s);
		} else if (methodName.startsWith("is")) {
			String s = methodName.substring(2, methodName.length());
			return decapitalize(s);
		} else {
			return null;
		}
	}

	public static <T> Method getReadMethodFromWriteMethod(Class<T> c,
			Method writeMethod) {
		Assertion.notNull(c);
		Assertion.notNull(writeMethod);
		final String methodName = writeMethod.getName();
		String propertyName = getPropertyName(methodName);
		Class<?>[] params = writeMethod.getParameterTypes();
		Class<?> param = params[0];
		String prefix = (params.length == 1 && (param == Boolean.class || param == Boolean.TYPE)) ? "is"
				: "get";
		String readMethodName = prefix + capitalize(propertyName);
		return MethodUtil.getDeclaredMethodNoException(c, readMethodName,
				Constants.EMPTY_CLASS_ARRAY);
	}

	public static <T> Method getWriteMethodFromReadMethod(Class<T> c,
			Method readMethod) {
		Assertion.notNull(c);
		Assertion.notNull(readMethod);
		final String methodName = readMethod.getName();
		String propertyName = getPropertyName(methodName);
		String writeMethodName = "set" + capitalize(propertyName);
		return MethodUtil.getDeclaredMethodNoException(c, writeMethodName,
				new Class<?>[] { readMethod.getReturnType() });
	}

	public static boolean isGetMethod(String methodName, Method m) {
		if (!methodName.startsWith("get")) {
			return false;
		}
		return (m.getParameterTypes().length == 0 && !methodName
				.equals("getClass"));
	}

	public static boolean isSetMethod(String methodName, Method m) {
		if (!methodName.startsWith("set")) {
			return false;
		}
		return (m.getParameterTypes().length == 1 && !methodName
				.equals("setClass"));
	}

	public static boolean isIsMethod(String methodName, Method m) {
		if (!methodName.startsWith("is")) {
			return false;
		}
		return (m.getParameterTypes().length == 0 && m.getReturnType().equals(
				Boolean.TYPE));
	}

	public static boolean isSetMethod(String methodName) {
		if (StringUtil.isEmpty(methodName)) {
			return false;
		}
		if (!methodName.startsWith("set")) {
			return false;
		}
		int len = "set".length() + 1;
		return isAppliedJavaBeanMethod(methodName, len);
	}

	public static boolean isIsMethod(String methodName) {
		if (StringUtil.isEmpty(methodName)) {
			return false;
		}
		if (!methodName.startsWith("is")) {
			return false;
		}
		int len = "is".length() + 1;
		return isAppliedJavaBeanMethod(methodName, len);
	}

	private static boolean isAppliedJavaBeanMethod(String methodName, int len) {
		if (methodName.length() > len) {
			return Character.isUpperCase(methodName.charAt(len - 1));
		} else {
			return false;
		}
	}

	public static Class<?> findPropertyTypeFromWriteMethod(Method writeMethod) {
		Assertion.notNull(writeMethod);
		Class<?>[] parameterTypes = writeMethod.getParameterTypes();
		if (parameterTypes.length > 0) {
			return parameterTypes[0];
		}
		throw new IllegalStateException(
				"can not find property from write method : "
						+ writeMethod.getName());
	}

}
