package commons.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

import commons.exception.IORuntimeException;

/**
 * JarFile utility.
 * 
 * @author shot
 * 
 */
public class JarFileUtil {

	private JarFileUtil() {
	}

	public static JarFile create(final String file) {
		try {
			return new JarFile(file);
		} catch (final IOException e) {
			throw new IORuntimeException(e);
		}
	}

	public static JarFile create(final File file) {
		try {
			return new JarFile(file);
		} catch (final IOException e) {
			throw new IORuntimeException(e);
		}
	}

	public static InputStream getInputStream(final JarFile file,
			final ZipEntry entry) {
		try {
			return file.getInputStream(entry);
		} catch (final IOException e) {
			throw new IORuntimeException(e);
		}
	}

	public static JarFile toJarFile(final URL jarUrl) {
		final URLConnection con = URLUtil.openConnection(jarUrl);
		if (con instanceof JarURLConnection) {
			return JarURLConnectionUtil.getJarFile((JarURLConnection) con);
		}
		return create(new File(toJarFilePath(jarUrl)));
	}

	public static String toJarFilePath(final URL jarUrl) {
		final URL nestedUrl = URLUtil.create(jarUrl.getPath());
		final String nestedUrlPath = nestedUrl.getPath();
		final int pos = nestedUrlPath.lastIndexOf('!');
		final String jarFilePath = nestedUrlPath.substring(0, pos);
		final File jarFile = new File(URLUtil.decode(jarFilePath, "UTF8"));
		return FileUtil.getCanonicalPath(jarFile);
	}

	public static void close(final JarFile jarFile) {
		try {
			jarFile.close();
		} catch (final IOException e) {
			throw new IORuntimeException(e);
		}
	}

}
