package commons.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;

import commons.exception.IORuntimeException;

/**
 * File utility.
 * 
 * @author shot
 * 
 */
public class FileUtil {

	protected FileUtil() {
	}

	public static String getCanonicalPath(File file) {
		try {
			return file.getCanonicalPath();
		} catch (IOException e) {
			throw new IORuntimeException(e);
		}
	}

	@Deprecated
	public static URL toURL(final File file) {
		try {
			return file.toURL();
		} catch (final IOException e) {
			throw new IORuntimeException(e);
		}
	}

	public static byte[] getBytes(File file) {
		return StreamUtil.getBytes(StreamUtil.createFileInputStream(file));
	}

	public static void copy(File src, File dest) {
		if (dest.canWrite() == false
				|| (dest.exists() && dest.canWrite() == false)) {
			return;
		}
		BufferedInputStream in = null;
		BufferedOutputStream out = null;
		try {
			in = StreamUtil.createBufferedFileInputStream(src);
			out = StreamUtil.createBufferedFileOutputStream(dest);
			byte[] buf = new byte[1024];
			int length;
			while (-1 < (length = in.read(buf))) {
				out.write(buf, 0, length);
				out.flush();
			}
		} catch (IOException e) {
			throw new IORuntimeException(e);
		} finally {
			StreamUtil.close(in);
			StreamUtil.close(out);
		}
	}

}
