package commons.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * Empties is an utility class that holds some empty return subclasses, such as
 * EmptyIterator.
 * 
 * @author shot
 */
public class Empties {

	public static class EmptyIterator<T> implements Iterator<T> {

		@Override
		public boolean hasNext() {
			return false;
		}

		@Override
		public T next() {
			return null;
		}

		@Override
		public void remove() {
		}

	}

	public static class EmptyEnumeration<T> implements Enumeration<T> {

		@Override
		public boolean hasMoreElements() {
			return false;
		}

		@Override
		public T nextElement() {
			return null;
		}

	}

}
