package commons.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DateUtil {

	public static SimpleDateFormat getSimpleDateFormat(final String pattern,
			final Locale locale) {
		if (pattern != null) {
			return new SimpleDateFormat(pattern, locale);
		} else {
			String p = findPattern(locale);
			return new SimpleDateFormat(p, locale);
		}
	}

	public static String findPattern(Locale locale) {
		SimpleDateFormat df = (SimpleDateFormat) DateFormat.getDateInstance(
				DateFormat.SHORT, locale);
		String pattern = df.toPattern();
		int index = pattern.indexOf(' ');
		if (index > 0) {
			pattern = pattern.substring(0, index);
		}
		if (pattern.indexOf("yyyy") < 0) {
			pattern = StringUtil.replace(pattern, "yy", "yyyy");
		}
		if (pattern.indexOf("MM") < 0) {
			pattern = StringUtil.replace(pattern, "M", "MM");
		}
		if (pattern.indexOf("dd") < 0) {
			pattern = StringUtil.replace(pattern, "d", "dd");
		}
		return pattern;
	}

}
