package commons.util;

import commons.Constants;

/**
 * Utility for HTTP content-type.
 * 
 * @author shot
 */
public class ContentTypeUtil {

	public static String getContentType(String contentType) {
		if (contentType == null) {
			return Constants.HTML_CONTENT_TYPE;
		}
		String[] strs = StringUtil.split(contentType, ",");
		String[] contentTypes = removeSemiColon(strs);
		for (int i = 0; i < contentTypes.length; i++) {
			if (isHtmlContentType(contentTypes[i].trim())) {
				return Constants.HTML_CONTENT_TYPE;
			}
		}
		for (int i = 0; i < contentTypes.length; i++) {
			if (isXmlContentType(contentTypes[i].trim())) {
				return Constants.XHTML_CONTENT_TYPE;
			}
		}
		return Constants.HTML_CONTENT_TYPE;
	}

	protected static String[] removeSemiColon(String[] contentTypes) {
		for (int i = 0; i < contentTypes.length; i++) {
			String type = contentTypes[i];
			int index = type.indexOf(";");
			if (index != -1) {
				type = type.substring(0, index);
				contentTypes[i] = type;
			}
		}
		return contentTypes;
	}

	public static boolean isHtmlContentType(String type) {
		return type.indexOf(Constants.HTML_CONTENT_TYPE) != -1
				|| type.equals(Constants.ANY_CONTENT_TYPE);
	}

	public static boolean isXmlContentType(String type) {
		return type.indexOf(Constants.XHTML_CONTENT_TYPE) != -1
				|| type.indexOf(Constants.APPLICATION_XML_CONTENT_TYPE) != -1
				|| type.indexOf(Constants.TEXT_XML_CONTENT_TYPE) != -1;
	}

	public static String getEncodingFromContentType(String contentType) {
		if (contentType == null) {
			return null;
		}
		if (contentType != null) {
			int semi = contentType.indexOf(';');
			if (semi >= 0) {
				String sub = contentType.substring(semi + 1).trim();
				if (sub.toLowerCase().startsWith(Constants.PREFIX_CHARSET)) {
					return sub.substring(Constants.PREFIX_CHARSET.length())
							.trim();
				}
			}
		}
		return null;

	}
}
