package commons.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

import commons.util.Empties.EmptyEnumeration;

/**
 * CollectionsUtil is a helper class to create parameterized collections like
 * ArrayList<T>, HashMap<K, V>.
 * 
 * @author shot
 */
public class CollectionsUtil {

	public static <T> List<T> newArrayList() {
		return new ArrayList<T>();
	}

	public static <T> List<T> newArrayList(List<T> list) {
		return new ArrayList<T>(list);
	}

	public static <T> List<T> newLinkedList() {
		return new LinkedList<T>();
	}

	public static <T> List<T> newSynchronizedList(List<T> list) {
		return Collections.synchronizedList(Assertion.notNull(list));
	}

	public static <T> List<T> newUnmodifiableArrayList() {
		return newUnmodifiableList(new ArrayList<T>());
	}

	public static <T> List<T> newUnmodifiableList(List<T> list) {
		return Collections.unmodifiableList(list);
	}

	public static <K, V> HashMap<K, V> newHashMap() {
		return new HashMap<K, V>();
	}

	public static <K, V> Map<K, V> newHashMap(Map<K, V> map) {
		return new HashMap<K, V>(map);
	}

	public static <T> Queue<T> newConcurrentLinkedQueue() {
		return new ConcurrentLinkedQueue<T>();
	}

	public static <K, V> Map<K, V> newConcurrentHashMap() {
		return new ConcurrentHashMap<K, V>();
	}

	public static <K, V> Map<K, V> newWeakHashMap() {
		return new WeakHashMap<K, V>();
	}

	public static <K, V> Map<K, V> newSynchronizedWeakHashMap() {
		return Collections.synchronizedMap(new WeakHashMap<K, V>());
	}

	public static <K, V> Map<K, V> newLinkedHashMap() {
		return new LinkedHashMap<K, V>();
	}

	public static <T> Set<T> newHashSet() {
		return new HashSet<T>();
	}

	public static <T> Set<T> newConcurrentHashSet() {
		return Collections.synchronizedSet(new HashSet<T>());
	}

	public static <T> Enumeration<T> emptyEnumeration() {
		return new EmptyEnumeration<T>();
	}

	public static <T> List<T> emptyList() {
		return Collections.emptyList();
	}

	public static <K, V> Map<K, V> emptyMap() {
		return Collections.emptyMap();
	}

	public static <T> Stack<T> newStack() {
		return new Stack<T>();
	}

	public static <K, V> CaseInsensitiveMap<K, V> newCaseInsensitiveMap() {
		return CaseInsensitiveMap.newCaseInsensitiveMap();
	}

	public static <K, V> ArrayMap<K, V> newArrayMap() {
		return ArrayMap.newArrayMap();
	}

	public static <T> IteratorEnumeration<T> newIteratorEnumeration(
			Iterator<T> iterator) {
		return new IteratorEnumeration<T>(iterator);
	}

	public static <E> EnumerationIterable<E> newEnumerationIterable(
			Enumeration<E> e) {
		return new EnumerationIterable<E>(e);
	}

	public static <E> EnumerationIterator<E> newEnumerationIterator(
			Enumeration<E> e) {
		return new EnumerationIterator<E>(e);
	}

	public static class IteratorEnumeration<T> implements Enumeration<T> {

		protected Iterator<T> iterator;

		public IteratorEnumeration(Iterator<T> iterator) {
			this.iterator = Assertion.notNull(iterator);
		}

		@Override
		public boolean hasMoreElements() {
			return iterator.hasNext();
		}

		@Override
		public T nextElement() {
			return iterator.next();
		}

	}

	/**
	 * 
	 * @author shot
	 * 
	 * @param <T>
	 */
	public static class EnumerationIterable<T> implements Iterable<T> {

		protected Enumeration<T> e;

		public EnumerationIterable(Enumeration<T> e) {
			this.e = Assertion.notNull(e);
		}

		@Override
		public Iterator<T> iterator() {
			return new EnumerationIterator<T>(e);
		}

	}

	public static class EnumerationIterator<E> implements Iterator<E> {

		private Enumeration<E> enumeration = null;

		public EnumerationIterator(final Enumeration<E> e) {
			this.enumeration = Assertion.notNull(e);
		}

		public void remove() {
			throw new UnsupportedOperationException("remove");
		}

		public boolean hasNext() {
			return enumeration.hasMoreElements();
		}

		@Override
		public E next() {
			return enumeration.nextElement();
		}

	}

}
