package commons.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Case insensitive type of set.
 * 
 * @author shot
 * 
 * @param <E>
 */
public class CaseInsensitiveSet<E> extends AbstractSet<E> implements Set<E>,
		Serializable {

	private static final long serialVersionUID = 0L;

	private transient Map<E, Object> map;

	private static final Object PRESENT = new Object();

	public CaseInsensitiveSet() {
		map = CaseInsensitiveMap.newCaseInsensitiveMap();
	}

	public CaseInsensitiveSet(Collection<E> c) {
		final int capacity = Math.max((int) (c.size() / .75f) + 1, 16);
		map = CaseInsensitiveMap.newCaseInsensitiveMap(capacity);
		addAll(c);
	}

	public CaseInsensitiveSet(int initialCapacity) {
		map = CaseInsensitiveMap.newCaseInsensitiveMap(initialCapacity);
	}

	public Iterator<E> iterator() {
		return map.keySet().iterator();
	}

	public int size() {
		return map.size();
	}

	public boolean isEmpty() {
		return map.isEmpty();
	}

	public boolean contains(Object o) {
		return map.containsKey(o);
	}

	public boolean add(E o) {
		return map.put(o, PRESENT) == null;
	}

	public boolean remove(Object o) {
		return map.remove(o) == PRESENT;
	}

	public void clear() {
		map.clear();
	}

	public static <E> CaseInsensitiveSet<E> set() {
		return new CaseInsensitiveSet<E>();
	}

	public static <E> CaseInsensitiveSet<E> set(Collection<E> c) {
		return new CaseInsensitiveSet<E>(c);
	}

	public static <E> CaseInsensitiveSet<E> set(int capacity) {
		return new CaseInsensitiveSet<E>(capacity);
	}

}
