package commons.util;

import java.util.Iterator;
import java.util.Map;

/**
 * Case insensitive type of map.
 * 
 * @author shot
 * 
 * @param <K>
 * @param <V>
 */
public class CaseInsensitiveMap<K, V> extends ArrayMap<K, V> {

	private static final long serialVersionUID = 1L;

	public static <K, V> CaseInsensitiveMap<K, V> newCaseInsensitiveMap() {
		return new CaseInsensitiveMap<K, V>();
	}

	public static <K, V> CaseInsensitiveMap<K, V> newCaseInsensitiveMap(
			int capacity) {
		return new CaseInsensitiveMap<K, V>(capacity);
	}

	public CaseInsensitiveMap() {
		super();
	}

	public CaseInsensitiveMap(int capacity) {
		super(capacity);
	}

	public final boolean containsKey(String key) {
		return super.containsKey(convertKey(key));
	}

	public final V get(Object key) {
		return super.get(convertKey(key));
	}

	public final V put(K key, V value) {
		return super.put(convertKey(key), value);
	}

	@SuppressWarnings("unchecked")
	public final void putAll(Map map) {
		for (Iterator<?> i = map.entrySet().iterator(); i.hasNext();) {
			Map.Entry<K, V> entry = (java.util.Map.Entry<K, V>) i.next();
			put(convertKey(entry.getKey()), entry.getValue());
		}
	}

	public final V remove(Object key) {
		return super.remove(convertKey(key));
	}

	public boolean containsKey(Object key) {
		return super.containsKey(convertKey(key));
	}

	@SuppressWarnings("unchecked")
	protected K convertKey(Object key) {
		return (K) ((String) key).toLowerCase();
	}

}
