package commons.util;

import java.util.Map;

import commons.Constants;

/**
 * Java auto boxing may be caused NullPointerException when wrapper to
 * primitive. This utility class helps to convert with return default value when
 * wrapper is null.
 * 
 * @author shot
 */
public class AutoboxingUtil {

	private static Map<Class<?>, Object> primitiveToDefaultValueMap = CollectionsUtil
			.newHashMap();

	static {
		primitiveToDefaultValueMap.put(void.class, null);
		primitiveToDefaultValueMap.put(Character.TYPE,
				Constants.CHAR_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Byte.TYPE, Constants.BYTE_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Short.TYPE,
				Constants.SHORT_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Integer.TYPE,
				Constants.INT_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Long.TYPE, Constants.LONG_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Double.TYPE,
				Constants.DOUBLE_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Float.TYPE,
				Constants.FLOAT_DEFAULT_VALUE);
		primitiveToDefaultValueMap.put(Boolean.TYPE,
				Constants.BOOLEAN_DEFAULT_VALUE);
	}

	public static int toPrimitiveInt(Integer i) {
		if (i == null) {
			return 0;
		}
		return i.intValue();
	}

	public static double toPrimitiveDouble(Double d) {
		if (d == null) {
			return 0d;
		}
		return d.doubleValue();
	}

	public static float toPrimitiveFloat(Float f) {
		if (f == null) {
			return 0f;
		}
		return f.floatValue();
	}

	public static long toPrimitiveLong(Long l) {
		if (l == null) {
			return 0L;
		}
		return l.longValue();
	}

	public static short toPrimitiveShort(Short s) {
		if (s == null) {
			return 0;
		}
		return s.shortValue();
	}

	public static char toPrimitiveCharacter(Character c) {
		if (c == null) {
			return Constants.CHAR_DEFAULT_VALUE;
		}
		return c.charValue();
	}

	public static Integer[] toIntegerArray(int[] array) {
		if (array == null || array.length == 0) {
			return Constants.EMPTY_INT_ARRAY;
		}
		Integer[] ret = new Integer[array.length];
		for (int i = 0; i < array.length; i++) {
			ret[i] = Integer.valueOf(array[i]);
		}
		return ret;
	}

	public static Double[] toDoubleArray(double[] array) {
		if (array == null || array.length == 0) {
			return Constants.EMPTY_DOUBLE_ARRAY;
		}
		Double[] ret = new Double[array.length];
		for (int i = 0; i < array.length; i++) {
			ret[i] = Double.valueOf(array[i]);
		}
		return ret;
	}

	public static Object getDefaultValueIfNull(Class<?> type, Object value) {
		if (value != null) {
			return value;
		}
		if (type == int.class) {
			return Constants.INT_DEFAULT_VALUE;
		} else if (type == double.class) {
			return Constants.DOUBLE_DEFAULT_VALUE;
		} else if (type == long.class) {
			return Constants.LONG_DEFAULT_VALUE;
		} else if (type == float.class) {
			return Constants.FLOAT_DEFAULT_VALUE;
		} else if (type == short.class) {
			return Constants.SHORT_DEFAULT_VALUE;
		} else if (type == boolean.class) {
			return Constants.BOOLEAN_DEFAULT_VALUE;
		} else if (type == byte.class) {
			return Constants.BYTE_DEFAULT_VALUE;
		}
		return value;
	}

	public static Object getDefaultPrimitiveValue(Class<?> clazz) {
		if (clazz == null || !clazz.isPrimitive()) {
			return null;
		}
		return primitiveToDefaultValueMap.get(clazz);
	}

}
