package commons.util;

/**
 * An assertion utility just for simple checks.
 * 
 * @author shot
 */
public class Assertion {

	public static <T> T notNull(T target) {
		return notNull(target, null);
	}

	public static <T> T notNull(T target, String message) {
		if (target == null) {
			throw new NullPointerException(message);
		}
		return target;
	}

	public static <T> T[] notNulls(T... args) {
		notNull(args);
		for (int i = 0; i < args.length; i++) {
			notNull(args[i]);
		}
		return args;
	}

	public static <T> boolean isNotNull(T t) {
		return (t != null);
	}

	public static <T> boolean hasNotNull(T... args) {
		return !hasNull(args);
	}

	public static <T> boolean isNull(T t) {
		return (t == null);
	}

	public static <T> boolean hasNull(T... args) {
		notNull(args);
		for (T t : args) {
			if (t == null) {
				return true;
			}
		}
		return false;
	}

	public static <T> boolean isAllNull(T... args) {
		notNull(args);
		for (T t : args) {
			if (t != null) {
				return false;
			}
		}
		return true;
	}
}
