package commons.util;

import java.lang.reflect.Array;

/**
 * ArrayUtil is an utility class for processing array.
 * 
 * @author shot
 */
public class ArrayUtil {

	@SuppressWarnings("unchecked")
	public static <T> T[] add(T[] current, T value) {
		Assertion.notNull(current);
		T[] newone = (T[]) Array.newInstance(current.getClass()
				.getComponentType(), current.length + 1);
		copyAll(current, newone);
		newone[current.length] = value;
		return newone;
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] addFirst(T[] current, T value) {
		Assertion.notNull(current);
		T[] newone = (T[]) Array.newInstance(current.getClass()
				.getComponentType(), current.length + 1);
		copy(current, newone, 0, 1, current.length);
		newone[0] = value;
		return newone;
	}

	@SuppressWarnings("unchecked")
	public static <T> T[] addAll(T[] from, T[] to) {
		Assertion.notNulls(from, to);
		T[] newone = (T[]) Array.newInstance(
				from.getClass().getComponentType(), from.length + to.length);
		copyAll(from, newone);
		copy(to, newone, 0, from.length, to.length);
		return newone;
	}

	public static <T> T[] copyAll(T[] from, T[] to) {
		System.arraycopy(from, 0, to, 0, from.length);
		return to;
	}

	public static <T> T[] copy(T[] from, T[] to, int fromPos, int toPos,
			int length) {
		System.arraycopy(from, fromPos, to, toPos, length);
		return to;
	}

	public static <T> boolean contains(T[] array, T element) {
		if (array == null || element == null) {
			return false;
		}
		for (T t : array) {
			if (element.equals(t)) {
				return true;
			}
		}
		return false;
	}
}
