package commons.ut;

/**
 * UtPlugin is simple plugin for extending test case.
 * 
 * @author shot
 * 
 */
public interface UtPlugin {

	void begin() throws Throwable;

	void setUp() throws Throwable;

	void setUpEach() throws Throwable;

	long beginMeasure();

	void runTest() throws Throwable;

	void endMeasure(long start);

	void handleRunTestThrowable(Throwable running);

	void handleTearDownThrowable(Throwable tearingDown);

	void tearDownEach() throws Throwable;

	void tearDown() throws Throwable;

	void end() throws Throwable;
}
