package commons.ut;

import junit.framework.TestCase;

/**
 * BaseTestCase is an abstract TestCase with plugin architecture.
 * 
 * @author shot
 * 
 */
public abstract class BaseTestCase extends TestCase {

	protected boolean measurable = false;

	@Override
	public void runBare() throws Throwable {
		final UtPlugin plugin = createUtPlugin();
		measurable = isMeasurable();
		Throwable exception = null;
		try {
			plugin.begin();
			try {
				plugin.setUp();
				try {
					plugin.setUpEach();
					long start = 0L;
					try {
						if (measurable) {
							start = plugin.beginMeasure();
						}
						try {
							plugin.runTest();
						} catch (Throwable running) {
							plugin.handleRunTestThrowable(running);
							exception = running;
						}
					} finally {
						if (measurable) {
							plugin.endMeasure(start);
						}
					}
				} finally {
					plugin.tearDownEach();
				}
			} finally {
				try {
					plugin.tearDown();
				} catch (Throwable tearingDown) {
					plugin.handleTearDownThrowable(tearingDown);
					if (exception == null) {
						exception = tearingDown;
					}
				}
			}
			if (exception != null) {
				throw exception;
			}
		} finally {
			plugin.end();
			setDefaultMeasurable();
		}
	}

	protected boolean isMeasurable() {
		return measurable;
	}

	protected void setDefaultMeasurable() {
		measurable = false;
	}

	protected void setMeasurable(boolean measurable) {
		this.measurable = measurable;
	}

	protected UtPlugin createUtPlugin() {
		return new DefaultUtPlugin(this);
	}

	@Override
	public void setUp() throws Exception {
	}

	@Override
	public void runTest() throws Throwable {
		super.runTest();
	}

	@Override
	public void tearDown() throws Exception {
	}

	public void success() {
		assertTrue(true);
	}
}
