package commons.mock;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletContext;

import commons.util.CollectionsUtil;
import commons.util.CollectionsUtil.IteratorEnumeration;

public class MockServletConfigImpl implements MockServletConfig, Serializable {

	private static final long serialVersionUID = 1L;

	protected String servletName;

	protected ServletContext servletContext;

	protected Map<String, String> initParameters = CollectionsUtil.newHashMap();

	public MockServletConfigImpl() {
	}

	public String getServletName() {
		return servletName;
	}

	public void setServletName(String servletName) {
		this.servletName = servletName;
	}

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	public String getInitParameter(String name) {
		return initParameters.get(name);
	}

	public void setInitParameter(final String name, final String value) {
		initParameters.put(name, value);
	}

	@SuppressWarnings("unchecked")
	public Enumeration getInitParameterNames() {
		return new IteratorEnumeration<String>(initParameters.keySet()
				.iterator());
	}
}