package commons.mock;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import commons.util.ArrayUtil;
import commons.util.CollectionsUtil;
import commons.util.ServletUtil;

public class MockRequestDispatcherImpl implements MockRequestDispatcher {

	protected String path;

	public MockRequestDispatcherImpl(final String path) {
		this.path = path;
	}

	@SuppressWarnings("unchecked")
	public void forward(ServletRequest request, ServletResponse response)
			throws ServletException, IOException {
		int question = path.indexOf('?');
		if (question >= 0) {
			MockHttpServletRequest req = MockHttpServletRequest.class
					.cast(request);
			Map<String, String[]> parameterMap = req.getParameterMap();
			Map<String, String[]> originalParameterMap = CollectionsUtil
					.newHashMap(parameterMap);
			parameterMap.clear();
			Map<String, String[]> map = ServletUtil.parseParameters(path
					.substring(question + 1), req.getCharacterEncoding());
			parameterMap.putAll(map);
			for (String key : originalParameterMap.keySet()) {
				String[] originalValue = originalParameterMap.get(key);
				String[] curValue = parameterMap.get(key);
				if (curValue == null) {
					parameterMap.put(key, originalValue);
				} else {
					final int currentLen = curValue.length;
					final int originalLen = originalValue.length;
					String[] newValue = new String[currentLen + originalLen];
					ArrayUtil.copyAll(curValue, newValue);
					ArrayUtil.copy(originalValue, newValue, 0, currentLen,
							originalLen);
					parameterMap.put(key, newValue);
				}
			}
		}
	}

	public void include(ServletRequest request, ServletResponse response)
			throws ServletException, IOException {
	}

	@Override
	public String getPath() {
		return path;
	}

}