package commons.mock;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;

import javax.servlet.ServletContext;

import commons.util.CollectionsUtil;
import commons.util.CollectionsUtil.IteratorEnumeration;

public class MockHttpSessionImpl implements MockHttpSession, Serializable {

	private static final long serialVersionUID = 2182279632419560836L;

	protected final long creationTime = System.currentTimeMillis();

	protected long lastAccessedTime = creationTime;

	protected ServletContext servletContext;

	protected String id;

	protected boolean new_ = true;

	protected boolean valid = true;

	protected int maxInactiveInterval = -1;

	protected Map<String, Object> attributes = CollectionsUtil.newHashMap();

	protected MockHttpServletRequest request;

	public MockHttpSessionImpl(final ServletContext servletContext,
			final MockHttpServletRequest request) {
		this.servletContext = servletContext;
		this.id = UUID.randomUUID().toString();
		this.request = request;
	}

	public long getCreationTime() {
		return creationTime;
	}

	public String getId() {
		return id;
	}

	public long getLastAccessedTime() {
		return lastAccessedTime;
	}

	public void access() {
		new_ = false;
		lastAccessedTime = System.currentTimeMillis();
	}

	public ServletContext getServletContext() {
		return servletContext;
	}

	public void setMaxInactiveInterval(int maxInactiveInterval) {
		this.maxInactiveInterval = maxInactiveInterval;
	}

	public int getMaxInactiveInterval() {
		return maxInactiveInterval;
	}

	public Object getAttribute(String name) {
		return attributes.get(name);
	}

	public void setAttribute(String name, Object value) {
		attributes.put(name, value);
	}

	public void removeAttribute(String name) {
		attributes.remove(name);
	}

	@Deprecated
	public javax.servlet.http.HttpSessionContext getSessionContext() {
		return null;
	}

	@Deprecated
	public Object getValue(String name) {
		return getAttribute(name);
	}

	@SuppressWarnings("unchecked")
	public Enumeration getAttributeNames() {
		return new IteratorEnumeration<String>(attributes.keySet().iterator());
	}

	@Deprecated
	public String[] getValueNames() {
		return (String[]) attributes.keySet().toArray(
				new String[attributes.size()]);
	}

	@Deprecated
	public void putValue(String name, Object value) {
		setAttribute(name, value);
	}

	@Deprecated
	public void removeValue(String name) {
		removeAttribute(name);
	}

	public void invalidate() {
		if (!valid) {
			return;
		}
		attributes.clear();
		valid = false;
		request.clearSession();
	}

	public boolean isNew() {
		return new_;
	}

	public boolean isValid() {
		return valid;
	}

	public void setValid(boolean valid) {
		this.valid = valid;
	}
}