package commons.mock;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletContext;

import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.CollectionsUtil.IteratorEnumeration;

public class MockFilterConfigImpl implements MockFilterConfig {

	protected Map<String, String> initParamMap = CollectionsUtil.newHashMap();

	protected String filterName;

	protected MockServletContext context;

	public MockFilterConfigImpl() {
		this.context = new MockServletContextImpl(null);
	}

	public MockFilterConfigImpl(final MockServletContext context) {
		this.context = context;
	}

	public MockFilterConfigImpl(String path) {
		this.context = new MockServletContextImpl(path);
	}

	@Override
	public String getFilterName() {
		return filterName;
	}

	@Override
	public String getInitParameter(String key) {
		return initParamMap.get(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Enumeration getInitParameterNames() {
		return new IteratorEnumeration<String>(initParamMap.keySet().iterator());
	}

	@Override
	public ServletContext getServletContext() {
		return context;
	}

	@Override
	public void addInitParameter(String key, String value) {
		Assertion.notNulls(key, value);
		initParamMap.put(key, value);
	}

	@Override
	public void setFilterName(String filterName) {
		this.filterName = Assertion.notNull(filterName);
	}

}
