package commons.meta.spi;

import commons.meta.BeanDesc;
import commons.meta.impl.BeanDescImpl;
import commons.meta.impl.SimpleBeanDescImpl;

/**
 * Default implementation of BeanDescCreator.
 * 
 * @author shot
 * @see commons.meta.spi.BeanDescCreator
 */
public class DefaultBeanDescCreatorImpl implements BeanDescCreator {

	@Override
	public <T> BeanDesc<T> createBeanDesc(Class<? extends T> componentClass) {
		return new BeanDescImpl<T>(componentClass);
	}

	@Override
	public <T> BeanDesc<T> createBeanDesc(T t, Class<? extends T> componentClass) {
		return new SimpleBeanDescImpl<T>(t, componentClass);
	}

}
