package commons.meta.impl;

import commons.meta.PackageDescHolder;
import commons.util.Assertion;

/**
 * @author shot
 */
public class SimpleBeanDescImpl<T> extends BeanDescImpl<T> {

	protected Class<? extends T> componentClass;

	public SimpleBeanDescImpl(T t, Class<? extends T> componentClass) {
		this(t, componentClass, null);
	}

	public SimpleBeanDescImpl(T component, Class<? extends T> componentClass,
			PackageDescHolder packageDescHolder) {
		super(componentClass, packageDescHolder);
		this.component = component;
		this.componentClass = Assertion.notNull(componentClass);
	}

	@Override
	public Class<? extends T> getComponentClass() {
		return componentClass;
	}

	@Override
	public T newInstance(Object... args) {
		return component;
	}
}
