package commons.meta.impl;

import commons.meta.PropertyDesc;
import commons.util.Assertion;

public class PropertyInjectConfigDesc extends AbstractInjectConfigDesc {

	protected String name;

	public PropertyInjectConfigDesc(PropertyDesc<?> pd) {
		setConfigDescContainer(Assertion.notNull(pd));
		this.name = pd.getPropertyName();
	}

	@Override
	public boolean isMethodTypeInject() {
		return false;
	}

	@Override
	public boolean isPropertyTypeInject() {
		return true;
	}

	@Override
	public String getName() {
		return name;
	}

}
