package commons.meta.impl;

import java.util.List;

import commons.exception.InvalidPackageException;
import commons.meta.BeanDesc;
import commons.meta.PackageDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;
import commons.util.Reflections.PackageUtil;

/**
 * @author shot
 */
public class PackageDescImpl extends AbstractConfigDescContainer implements
		PackageDesc {

	protected String packageName;

	protected Package package_;

	protected List<BeanDesc<?>> beanDescList = CollectionsUtil.newArrayList();

	protected List<Class<?>> classList = CollectionsUtil.newArrayList();

	public PackageDescImpl(final BeanDesc<?> beanDesc) {
		Assertion.notNull(beanDesc);
		Class<?> c = beanDesc.getComponentClass();
		this.packageName = PackageUtil.getPackageName(c);
		this.package_ = c.getPackage();
		if (package_ != null) {
			getConfigDescSupport().addAllAnnotationDesc(package_);
		}
		beanDescList.add(beanDesc);
		classList.add(c);
	}

	public <T> void addBeanDesc(BeanDesc<T> beanDesc) {
		Assertion.notNull(beanDesc);
		final Class<? extends T> c = beanDesc.getComponentClass();
		final String pName = PackageUtil.getPackageName(c);
		if (!packageName.equals(pName)) {
			throw new InvalidPackageException(packageName, pName);
		}
		beanDescList.add(beanDesc);
		classList.add(c);
	}

	public List<BeanDesc<?>> getBeanDescList() {
		return beanDescList;
	}

	public List<Class<?>> getClassList() {
		return classList;
	}

	public String getPackageName() {
		return packageName;
	}

	public Package getPackage() {
		return package_;
	}

}
