package commons.meta.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import commons.meta.NameDesc;
import commons.util.Assertion;

/**
 * @author shot
 */
public class NameDescImpl<T> implements NameDesc<T> {

	protected Object identifier;

	protected Pattern pattern;

	public NameDescImpl(Object identifier) {
		this(identifier, null);
	}

	public NameDescImpl(Object identifier, Pattern pattern) {
		this.identifier = Assertion.notNull(identifier);
		this.pattern = pattern;
	}

	@Override
	public Object getIdentifier() {
		return identifier;
	}

	@Override
	public Pattern getPattern() {
		return pattern;
	}

	@Override
	public boolean isIdentified(Object identifier) {
		Assertion.notNull(identifier);
		if (!identifier.equals(this.identifier)) {
			return false;
		}
		if (pattern == null) {
			return true;
		}
		Matcher matcher = pattern.matcher(identifier.toString());
		return matcher.matches();
	}

}
