package commons.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;

import commons.meta.ConfigDescContainer;
import commons.meta.ConfigType;
import commons.meta.InstanceConfigDesc;
import commons.util.Assertion;

/**
 * 
 * @author shot
 * 
 */
public abstract class AbstractInstanceConfigDesc implements InstanceConfigDesc {

	protected ConfigDescContainer container;

	@Override
	public ConfigDescContainer getConfigDescContainer() {
		return container;
	}

	@Override
	public void setConfigDescContainer(ConfigDescContainer container) {
		this.container = Assertion.notNull(container);
	}

	@Override
	public ElementType getElementType() {
		return ElementType.TYPE;
	}

	@Override
	public void setElementType(ElementType type) {
		// no op;
	}

	@Override
	public final ConfigType getConfigType() {
		return ConfigType.OUTER;
	}

	@Override
	public ElementType[] getAcceptableTypes() {
		return ElementType.values();
	}

	@Override
	public List<Annotation> getMetaAnnotationList() {
		return Collections.emptyList();
	}

	@Override
	public boolean isAcceptableType(ElementType type) {
		return true;
	}

	@Override
	public Annotation getAnnotation() {
		return null;
	}

	@Override
	public boolean hasAnnotation() {
		return false;
	}

}
