package commons.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;

import commons.Constants;
import commons.meta.ConfigDescContainer;
import commons.meta.ConfigType;
import commons.meta.InjectConfigDesc;
import commons.util.Assertion;

/**
 * 
 * @author shot
 * 
 */
public abstract class AbstractInjectConfigDesc implements InjectConfigDesc {

	protected ConfigDescContainer container;

	protected ElementType elementType;

	protected Class<?>[] parameterTypes = Constants.EMPTY_CLASS_ARRAY;

	@Override
	public Class<? extends InjectConfigDesc> getType() {
		return InjectConfigDesc.class;
	}

	@Override
	public ConfigDescContainer getConfigDescContainer() {
		return container;
	}

	@Override
	public void setConfigDescContainer(ConfigDescContainer container) {
		this.container = Assertion.notNull(container);
	}

	@Override
	public ElementType getElementType() {
		return elementType;
	}

	@Override
	public void setElementType(ElementType type) {
		this.elementType = Assertion.notNull(type);
	}

	@Override
	public final ConfigType getConfigType() {
		return ConfigType.OUTER;
	}

	@Override
	public ElementType[] getAcceptableTypes() {
		return ElementType.values();
	}

	@Override
	public List<Annotation> getMetaAnnotationList() {
		return Collections.emptyList();
	}

	@Override
	public boolean isAcceptableType(ElementType type) {
		return true;
	}

	@Override
	public Annotation getAnnotation() {
		return null;
	}

	@Override
	public boolean hasAnnotation() {
		return false;
	}

	@Override
	public Class<?>[] getParameterTypes() {
		return parameterTypes;
	}

	@Override
	public void setParameterTypes(Class<?>[] paramTypes) {
		this.parameterTypes = paramTypes;
	}

}
