package commons.meta.impl;

import java.util.List;

import commons.el.Expression;
import commons.meta.ConfigDesc;
import commons.meta.ConfigDescContainer;
import commons.meta.ConfigDescSupport;
import commons.meta.ExpressionAware;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * 
 * @author shot
 * 
 */
public abstract class AbstractConfigDescContainer implements
		ConfigDescContainer, ExpressionAware {

	protected ConfigDescSupport support = new ConfigDescSupport(this);

	protected List<Expression<?>> expressions = CollectionsUtil.newArrayList();

	@Override
	public ConfigDesc getConfigDesc(int index) {
		if (index < getConfigDescSize()) {
			return support.getConfigDesc(index);
		}
		return null;
	}

	@Override
	public int getConfigDescSize() {
		return support.getConfigDescSize();
	}

	@Override
	public List<ConfigDesc> getConfigDescs() {
		return support.getConfigDescs();
	}

	@Override
	public void addConfigDesc(ConfigDesc configDesc) {
		support.addConfigDesc(Assertion.notNull(configDesc));
	}

	@Override
	public ConfigDesc findConfigDesc(Class<?> clazz) {
		Assertion.notNull(clazz);
		return support.hasConfigDesc(clazz) ? findConfigDescs(clazz).get(0)
				: null;
	}

	@Override
	public List<ConfigDesc> findConfigDescs(Class<?> clazz) {
		return support.findConfigDescs(Assertion.notNull(clazz));
	}

	@Override
	public boolean hasConfigDesc() {
		return getConfigDescSize() > 0;
	}

	protected ConfigDescSupport getConfigDescSupport() {
		return support;
	}

	@Override
	public void addExpression(Expression<?> expression) {
		expressions.add(Assertion.notNull(expression));
	}

	@Override
	public Expression<?> getExpression(int index) {
		if (index < expressions.size()) {
			return expressions.get(index);
		}
		return null;
	}

	@Override
	public Expression<?>[] getExpressions() {
		return expressions.toArray(new Expression[0]);
	}

	@Override
	public int getExpressionSize() {
		return expressions.size();
	}

	@Override
	public boolean hasExpression() {
		return getExpressionSize() > 0;
	}

	@Override
	public ConfigDesc getConfigDesc(Class<?> clazz) {
		Assertion.notNull(clazz);
		return support.findConfigDesc(clazz);
	}

	@Override
	public boolean hasConfigDesc(Class<?> clazz) {
		Assertion.notNull(clazz);
		return support.hasConfigDesc(clazz);
	}

}
