package commons.meta.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.List;

import commons.meta.AspectConfigDesc;
import commons.meta.ConfigDescContainer;
import commons.meta.ConfigType;

/**
 * Abstract aspect config class.
 * 
 * @author shot
 * 
 */
public abstract class AbstractAspectConfigDesc implements AspectConfigDesc {

	@Override
	public Class<? extends AspectConfigDesc> getType() {
		return AspectConfigDesc.class;
	}

	@Override
	public ConfigDescContainer getConfigDescContainer() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void setConfigDescContainer(ConfigDescContainer container) {
		throw new UnsupportedOperationException();
	}

	@Override
	public ElementType getElementType() {
		throw new UnsupportedOperationException();
	}

	@Override
	public void setElementType(ElementType type) {
		throw new UnsupportedOperationException();
	}

	@Override
	public final ConfigType getConfigType() {
		return ConfigType.OUTER;
	}

	@Override
	public ElementType[] getAcceptableTypes() {
		return ElementType.values();
	}

	@Override
	public List<Annotation> getMetaAnnotationList() {
		return Collections.emptyList();
	}

	@Override
	public boolean isAcceptableType(ElementType type) {
		return true;
	}

	@Override
	public Annotation getAnnotation() {
		return null;
	}

	@Override
	public boolean hasAnnotation() {
		return false;
	}

}
