package commons.meta;

import java.lang.reflect.Method;

/**
 * PropertyDesc is a meta interface for method as JavaBean's accessor. Without
 * JavaBean's property, PropertyDesc should not be created, and MethodDesc
 * should be created instead.
 * 
 * @author shot
 */
public interface PropertyDesc<T> extends ConfigDescContainer, DescType,
		ExpressionAware {

	void setReadMethod(Method readMethod);

	void setReadMethodDesc(MethodDesc readMethodDesc);

	void setPropertyName(String propertyName);

	void setWriteMethod(Method writeMethod);

	void setWriteMethodDesc(MethodDesc writeMethodDesc);

	void setPropertyType(Class<?> propertyType);

	String getPropertyName();

	Class<?> getPropertyType();

	Method getReadMethod();

	MethodDesc getReadMethodDesc();

	Method getWriteMethod();

	MethodDesc getWriteMethodDesc();

	void setValue(T target, Object... args);

	Object getValue(T target);

	boolean isReadable();

	boolean isWritable();

	Class<T> getTargetClass();

	boolean isArray();
}
