package commons.meta;

import java.util.List;

/**
 * PackageDescHolder is an interface collecting PackageDescs.
 * 
 * @author shot
 */
public interface PackageDescHolder {

	PackageDesc getPackageDesc(String packageName);

	void addPackageDesc(PackageDesc packageDesc);

	int getPackageDescSize();

	List<PackageDesc> getPackageDescs();

	/**
	 * getClassList() returns List<Class<?>> that is belonged to the package.
	 * This method must not be null.
	 * 
	 * @param packageName
	 * @return List<Class<?>>
	 */
	List<Class<?>> getClassList(String packageName);
}
