package commons.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * MethodDesc is meta class of Method.
 * 
 * @author shot
 */
public interface MethodDesc extends ModifierDesc, ConfigDescContainer,
		ExpressionAware, DescType {

	Method getMethod();

	void setMethod(Method method);

	String getMethodName();

	void setMethodName(String methodName);

	Class<?>[] getParameterTypes();

	void setParameterTypes(Class<?>[] parameterTypes);

	Class<?>[] getExceptionTypes();

	Class<?> getReturnType();

	void setReturnType(Class<?> returnType);

	<T> Object invoke(T t, Object... args);

	Annotation[][] getParameterAnnotations();

	AnnotationDesc[][] getParameterAnnotationDescs();

	AnnotationDesc[] getParameterAnnotationDescs(int index);

	int getParameterAnnotationDescSize();
}
