package commons.meta;

import java.lang.annotation.Annotation;
import java.util.Map;

import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * Lookup information for composite annotation.
 * 
 * @author shot
 * 
 */
public class LookupContext {

	protected final Class<? extends Annotation> targetAnnotationClass;

	protected Map<String, Object> methodValueMap = CollectionsUtil.newHashMap();

	public LookupContext(Class<? extends Annotation> targetAnnotationClass) {
		this.targetAnnotationClass = Assertion.notNull(targetAnnotationClass);
	}

	public void addMethodValue(String methodName, Object value) {
		Assertion.notNull(methodName);
		Assertion.notNull(value);
		methodValueMap.put(methodName, value);
	}

	public Class<? extends Annotation> getTargetAnnotationClass() {
		return targetAnnotationClass;
	}

	public Object getValue(String methodName) {
		return methodValueMap.get(Assertion.notNull(methodName));
	}

	public boolean contains(String methodName) {
		return methodValueMap.containsKey(Assertion.notNull(methodName));
	}
}
