package commons.meta;

import java.util.Map;

import commons.exception.NoSuchInstaceConfigRuntimeException;
import commons.meta.impl.PrototypeInstanceConfigDesc;
import commons.meta.impl.SingletonInstanceConfigDesc;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * Instance creating factory.
 * 
 * @author shot
 * 
 */
public class InstanceConfigDescFactory {

	public static final String SINGLETON = "singleton";

	public static final String PROTOTYPE = "prototype";

	public static final String DEFAULT = SINGLETON;

	protected static final Map<String, InstanceConfigDesc> map = CollectionsUtil
			.newHashMap();

	static {
		map.put(SINGLETON, new SingletonInstanceConfigDesc());
		map.put(PROTOTYPE, new PrototypeInstanceConfigDesc());
	}

	public static InstanceConfigDesc getInstanceConfigDesc(String type) {
		Assertion.notNull(type);
		InstanceConfigDesc instanceConfigDesc = map.get(type);
		if (instanceConfigDesc == null) {
			throw new NoSuchInstaceConfigRuntimeException(type);
		}
		return instanceConfigDesc;
	}

	public static void addInstanceConfigDesc(InstanceConfigDesc instanceConfig) {
		Assertion.notNull(instanceConfig);
		map.put(instanceConfig.getName(), instanceConfig);
	}

}
