package commons.meta;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.List;

/**
 * ConfigDesc is the root interface of configuration.
 * 
 * @author shot
 * 
 */
public interface ConfigDesc {

	boolean hasAnnotation();

	Annotation getAnnotation();

	Class<?> getType();

	String getName();

	ElementType getElementType();

	void setElementType(ElementType type);

	void setConfigDescContainer(ConfigDescContainer container);

	ConfigDescContainer getConfigDescContainer();

	ConfigType getConfigType();

	ElementType[] getAcceptableTypes();

	boolean isAcceptableType(ElementType type);

	List<Annotation> getMetaAnnotationList();

}
