package commons.meta;

import java.util.List;
import java.util.Map;

/**
 * ClassDesc is a meta class for Class.
 * 
 * @author shot
 * 
 * @param <T>
 */
public interface ClassDesc<T> extends ConfigDescContainer, DescType,
		ExpressionAware {

	Class<? extends T> getComponentClass();

	Class<? extends T> getEnhancedComponentClass();

	Class<? extends T> getConcreteClass();

	void setEnhancedComponentClass(Class<? extends T> componentClass);

	List<Class<?>> getDependencyClassesList();

	Map<String, Class<?>[]> getClassesMap();

	boolean isUnacceptableClass(Class<?> c);

	String getComponentName();

}
