package commons.meta;

import java.util.Map;
import java.util.Set;

import commons.bootstrap.CommonsInitializer;
import commons.meta.spi.BeanDescCreator;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

/**
 * The factory class for creating BeanDesc.
 * 
 * @author shot
 * 
 */
public class BeanDescFactory {

	protected static final BeanDescCreator creator;

	static {
		if (!CommonsInitializer.isInitialized()) {
			CommonsInitializer.init();
		}
		creator = CommonsInitializer.getFactory().getBeanDescCreator();
	}

	@SuppressWarnings("unchecked")
	private static Map<Class, BeanDesc> cache = CollectionsUtil
			.newConcurrentHashMap();

	@SuppressWarnings("unchecked")
	public static <T> BeanDesc<T> getBeanDesc(Class<? extends T> componentClass) {
		Assertion.notNull(componentClass);
		BeanDesc<T> beanDesc = cache.get(componentClass);
		if (beanDesc != null) {
			return beanDesc;
		}
		beanDesc = createBeanDesc(componentClass);
		cache.put(componentClass, beanDesc);
		return beanDesc;
	}

	@SuppressWarnings("unchecked")
	public static <T> BeanDesc<T> getBeanDesc(T t) {
		Assertion.notNull(t);
		Class<T> componentClass = (Class<T>) t.getClass();
		BeanDesc<T> beanDesc = cache.get(componentClass);
		if (beanDesc != null) {
			return beanDesc;
		}
		beanDesc = createBeanDesc(t);
		cache.put(componentClass, beanDesc);
		return beanDesc;
	}

	public static <T> BeanDesc<T> createBeanDesc(
			Class<? extends T> componentClass) {
		return creator.createBeanDesc(componentClass);
	}

	@SuppressWarnings("unchecked")
	public static <T> BeanDesc<T> createBeanDesc(T t) {
		return creator.createBeanDesc(t, (Class<T>) t.getClass());
	}

	public static <T> boolean contains(Class<T> componentClass) {
		return cache.containsKey(componentClass);
	}

	public static void clear(Set<Class<?>> set) {
		for (Class<?> c : set) {
			if (contains(c)) {
				cache.remove(c);
			}
		}
	}

	public static void clear() {
		cache.clear();
	}
}
