package commons.meta;

import java.util.List;

/**
 * BeanDesc is an interface that holds all meta information about a bean.<br />
 * It may be JavaBeans, but not be required to be.
 * 
 * @author shot
 * 
 * @param <T>
 */
public interface BeanDesc<T> {

	/**
	 * Get a target component class.This method must return non-enhanced class.
	 * 
	 * @return componentClass
	 */
	Class<? extends T> getComponentClass();

	/**
	 * Get enhanced component class.
	 * 
	 * @return componentClass
	 */
	Class<? extends T> getEnhancedComponentClass();

	/**
	 * Get a target component class.This Class.class may be enhanced or may be
	 * not enhanced.
	 * 
	 * @return componentClass
	 */
	Class<? extends T> getConcreteClass();

	/**
	 * Set enhanced component class, which might be enhanced by AOP library.
	 * 
	 * @param enhancedClass
	 */
	void setEnhancedComponentClass(Class<? extends T> enhancedClass);

	/**
	 * Get component name if this instance has.If there is no name, return null.
	 * 
	 * @return name
	 */
	String getComponentName();

	/**
	 * Get NameDesc as a name meta class.
	 * 
	 * @return nameDesc : NameDesc
	 */
	NameDesc<T> getNameDesc();

	/**
	 * Set NameDesc.
	 * 
	 * @param nameDesc
	 */
	void setNameDesc(NameDesc<T> nameDesc);

	boolean hasName();

	PackageDesc getPackageDesc();

	ClassDesc<T> getClassDesc();

	PropertyDesc<T> getPropertyDesc(String propertyName);

	MethodDesc getMethodDesc(String methodName);

	List<MethodDesc> getMethodDescs(String methodName);

	T newInstance(Object... args);

	List<PropertyDesc<T>> getAllPropertyDesc();

	List<MethodDesc> getAllMethodDesc();

	ConstructorDesc<T> getConstructorDesc();

	int getPropertyDescSize();

	/**
	 * return component if registered by object, not class.
	 * 
	 * @return
	 */
	T getComponent();

	void setComponent(T component);

	boolean isSingleton();

	void setSingleton(boolean singleton);

	List<ConfigDesc> getConfigDescList(ConfigDescContainer container);

	List<ConfigDesc> getClassConfigDescList();

	List<ConfigDesc> getClassConfigDescList(Class<?>... types);

	List<ConfigDesc> getPackageConfigDescList();

	List<ConfigDesc> getPackageConfigDescList(Class<?>... types);

	List<ConfigDesc> getConstructorConfigDescList();

	List<ConfigDesc> getConstructorConfigDescList(Class<?>... types);

	List<ConfigDesc> getMethodConfigDescList();

	List<ConfigDesc> getMethodConfigDescList(Class<?>... types);
}
