package commons.exception;

import commons.util.Reflections.MethodUtil;

public class NoSuchMethodRuntimeException extends BaseRuntimeException {

	private static final long serialVersionUID = 1L;

	private String methodName;

	private Class<?>[] argTypes;

	public NoSuchMethodRuntimeException(NoSuchMethodException cause,
			Class<?> clazz, String methodName) {
		super(cause, "ECMN0015", cause, clazz.getName(), methodName);
	}

	public NoSuchMethodRuntimeException(String methodName) {
		super("ECMN0016", methodName);
	}

	public NoSuchMethodRuntimeException(Class<?> targetClass,
			String methodName, Class<?>[] argTypes, NoSuchMethodException cause) {
		super(cause, "ECMN0017", new Object[] { cause, targetClass.getName(),
				methodName, MethodUtil.getSignature(methodName, argTypes) });
		this.methodName = methodName;
		this.argTypes = argTypes;
	}

	public String getMethodName() {
		return methodName;
	}

	public Class<?>[] getArgTypes() {
		return argTypes;
	}

}
