package commons.exception;

import static commons.Constants.EMPTY_ARRAY;

/**
 * InstantiationRuntimeException is an exception class that may be occurred when
 * class instantiation fail.
 * 
 * @author shot
 */
public class InstantiationRuntimeException extends BaseRuntimeException {

	static final long serialVersionUID = 1L;

	private Class<?> targetClass;

	public InstantiationRuntimeException(Class<?> targetClass,
			InstantiationException cause) {
		this(targetClass, cause, EMPTY_ARRAY);
	}

	public InstantiationRuntimeException(Class<?> targetClass,
			InstantiationException cause, Object... args) {
		super(cause, "ECMN0002", targetClass.getName(), args);
		this.targetClass = targetClass;
	}

	public Class<?> getTargetClass() {
		return targetClass;
	}
}
