package commons.exception;

import static commons.Constants.EMPTY_ARRAY;

/**
 * IllegalAccessRuntimeException is an exception class wrapping
 * IllegalAccessException.
 * 
 * @author shot
 */
public class IllegalAccessRuntimeException extends BaseRuntimeException {

	private static final long serialVersionUID = 1L;

	private Class<?> targetClass;

	/**
	 * This constructor is for Field and Method reflections.
	 * 
	 * @param declaringClass
	 * @param type
	 * @param cause
	 */
	public IllegalAccessRuntimeException(Class<?> declaringClass,
			Class<?> type, IllegalAccessException cause) {
		super(cause, "ECMN0030", declaringClass.getName(), type.getName(),
				cause.getMessage());
	}

	public IllegalAccessRuntimeException(Class<?> targetClass,
			IllegalAccessException cause) {
		this(targetClass, cause, EMPTY_ARRAY);
	}

	public IllegalAccessRuntimeException(Class<?> targetClass,
			IllegalAccessException cause, Object... args) {
		super(cause, "ECMN0003", targetClass.getName(), cause.getMessage(),
				args);
		this.targetClass = targetClass;
	}

	public Class<?> getTargetClass() {
		return targetClass;
	}
}
