package commons.exception;

import commons.Constants;

/**
 * A runtime exception for ClassNotFoundException.
 * 
 * @author shot
 */
public class ClassNotFoundRuntimeException extends BaseRuntimeException {

	private static final long serialVersionUID = -9022468864937761059L;

	private String className;

	public ClassNotFoundRuntimeException(ClassNotFoundException cause) {
		this(null, cause);
	}

	public ClassNotFoundRuntimeException(String className,
			ClassNotFoundException cause) {
		this(className, cause, Constants.EMPTY_ARRAY);
	}

	public ClassNotFoundRuntimeException(String className,
			ClassNotFoundException cause, Object... args) {
		super("ECMN0005", (className != null) ? className : "", cause, args);
		setClassName(className);
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

}
