package commons.exception;

import static commons.Constants.EMPTY_ARRAY;

import commons.util.MessageFormatter;

/**
 * The base runtime exception. Instead of RuntimeException, BaseRuntimeException
 * is enable to load message from given message code.
 * 
 * @author shot
 * @see java.lang.RuntimeException
 */
public class BaseRuntimeException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	protected String messageCode;

	protected Object[] args;

	public BaseRuntimeException() {
		this("ECMN0001", EMPTY_ARRAY);
	}

	public BaseRuntimeException(String messageCode, Object... args) {
		this(null, messageCode, args);
	}

	public BaseRuntimeException(Throwable cause, String messageCode,
			Object... args) {
		super(MessageFormatter.getMessage(messageCode, args), cause);
		this.messageCode = messageCode;
		this.args = args;
	}

	public String getMessageCode() {
		return messageCode;
	}

	public Object[] getArgs() {
		return args;
	}

}
