package commons.dataset.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import commons.dataset.DataColumn;
import commons.dataset.DataRow;
import commons.dataset.DataTable;
import commons.dataset.DataType;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class DataTableImpl implements DataTable {

	protected String tableName;

	protected LinkedList<DataRow> rowlist = new LinkedList<DataRow>();

	protected Map<String, DataColumn> columnmap = CollectionsUtil.newHashMap();

	protected List<String> columnNameList = CollectionsUtil.newArrayList();

	public DataTableImpl(String tableName) {
		this.tableName = Assertion.notNull(tableName);
	}

	@Override
	public DataColumn addColumn(String columnName) {
		return addColumn(columnName, DataType.OBJECT);
	}

	@Override
	public DataColumn addColumn(String columnName, DataType type) {
		Assertion.notNull(columnName);
		int index = columnmap.size();
		DataColumn column = new DataColumnImpl(columnName, index, type);
		columnNameList.add(index, columnName);
		columnmap.put(columnName, column);
		return column;
	}

	@Override
	public DataRow addRow() {
		DataRow row = new DataRowImpl(this);
		rowlist.addLast(row);
		return row;
	}

	@Override
	public DataColumn getColumn(String columnName) {
		return columnmap.get(Assertion.notNull(columnName));
	}

	@Override
	public DataColumn getColumn(int index) {
		String name = columnNameList.get(index);
		return columnmap.get(name);
	}

	@Override
	public DataRow getRow(int index) {
		return rowlist.get(index);
	}

	@Override
	public int getRowSize() {
		return rowlist.size();
	}

	@Override
	public String getTableName() {
		return tableName;
	}

	@Override
	public void setTableName(String tableName) {
		this.tableName = Assertion.notNull(tableName);
	}

	@Override
	public int getColumnSize() {
		return columnNameList.size();
	}

}
