package commons.dataset.impl;

import java.util.List;
import java.util.Map;

import commons.dataset.DataSet;
import commons.dataset.DataTable;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class DataSetImpl implements DataSet {

	protected Map<String, DataTable> tableMap = CollectionsUtil.newHashMap();

	protected List<DataTable> tableList = CollectionsUtil.newArrayList();

	@Override
	public DataTable addDataTable(String name) {
		Assertion.notNull(name);
		DataTable table = new DataTableImpl(name);
		tableMap.put(name, table);
		tableList.add(table);
		return table;
	}

	@Override
	public List<DataTable> getAllDataTable() {
		List<DataTable> list = CollectionsUtil.newArrayList();
		list.addAll(tableMap.values());
		return list;
	}

	@Override
	public DataTable getDataTable(String name) {
		return tableMap.get(Assertion.notNull(name));
	}

	@Override
	public DataTable getDataTable(int index) {
		return tableList.get(index);
	}

}
