package commons.dataset.impl;

import java.util.List;

import commons.dataset.DataColumn;
import commons.dataset.DataRow;
import commons.dataset.DataTable;
import commons.util.Assertion;
import commons.util.CollectionsUtil;

public class DataRowImpl implements DataRow {

	protected List<Object> valueList = CollectionsUtil.newArrayList();

	protected DataTable table;

	public DataRowImpl(DataTable table) {
		this.table = Assertion.notNull(table);
	}

	@Override
	public Object getValue(int columnIndex) {
		return valueList.get(columnIndex);
	}

	@Override
	public Object getValue(String columnName) {
		Assertion.notNull(columnName);
		DataColumn column = table.getColumn(columnName);
		int index = column.getColumnIndex();
		return valueList.get(index);
	}

	@Override
	public DataRow setValue(int columnIndex, Object value) {
		Assertion.notNull(value);
		if (columnIndex < valueList.size()) {
			valueList.set(columnIndex, value);
		} else {
			valueList.add(columnIndex, value);
		}
		return this;
	}

	@Override
	public DataRow setValue(String columnName, Object value) {
		Assertion.notNulls(columnName, value);
		DataColumn column = table.getColumn(columnName);
		int index = column.getColumnIndex();
		setValue(index, value);
		return this;
	}

}
