package commons.dataset.impl;

import commons.dataset.DataColumn;
import commons.dataset.DataType;
import commons.util.Assertion;

public class DataColumnImpl implements DataColumn {

	protected String columnName;

	protected int index;

	protected DataType type;

	public DataColumnImpl(String columnName, int index, DataType type) {
		this.columnName = Assertion.notNull(columnName);
		this.index = index;
		this.type = Assertion.notNull(type);
	}

	@Override
	public int getColumnIndex() {
		return index;
	}

	@Override
	public String getColumnName() {
		return columnName;
	}

	@Override
	public DataType getType() {
		return type;
	}

	@Override
	public void setType(DataType type) {
		this.type = Assertion.notNull(type);
	}

}
