package commons.bootstrap;

import java.util.Iterator;
import java.util.ServiceLoader;

import commons.util.Assertion;

/**
 * CommonsInitializer is the base loader utility class using ServiceLoader.
 * 
 * @author shot
 * @see java.util.ServiceLoader
 */
public class CommonsInitializer {

	protected static CommonsFactory factory;

	protected static boolean initialized = false;

	protected static Object lock = new Object();

	public static synchronized void init() {
		synchronized (lock) {
			factory = get(load(CommonsFactory.class));
			factory.initialize();
			initialized = true;
		}
	}

	public static boolean isInitialized() {
		return initialized;
	}

	public static CommonsFactory getFactory() {
		return factory;
	}

	public static void destroy() {
		synchronized (lock) {
			factory.destroy();
			factory = null;
			initialized = false;
		}
	}

	public static <S> S get(Class<S> serviceClass) {
		return get(load(Assertion.notNull(serviceClass)));
	}

	public static <S> ServiceLoader<S> load(Class<S> service) {
		return ServiceLoader.load(service);
	}

	public static <S> S get(ServiceLoader<S> loader) {
		return iterator(loader).next();
	}

	public static <S> Iterator<S> iterator(ServiceLoader<S> loader) {
		return loader.iterator();
	}

}
